﻿<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Deklaracja Z-7</title>
		<script runat="server">
	
	static readonly string dots = "</strong>. . . . . . . . . . . .<strong>";

    void Licz1Strona(Zwolnienie zwolnienie) {
        NieobecnośćOd.EditValue = zwolnienie.OkresNieobecności.From;
        NieobecnośćDo.EditValue = zwolnienie.OkresNieobecności.To;

        Periods zas = Periods.Empty;
        Periods wynagr = Periods.Empty;
        ArrayList lista = new ArrayList();
        Hashtable ht = new Hashtable();
        Wyplata wypzas = null;
        foreach (WypElement e in zwolnienie.Poprzednie)
                if (WypElement.ZasiłekZUS.Eval(e)) {
                    if (e.Data < zwolnienie.Elementy[0].Data) {
                        zas += e.Okres;
                        if (wypzas == null || wypzas.Data < e.Wyplata.Data)
                            wypzas = e.Wyplata;
                    }
                }
                else {
                    wynagr += e.Okres;
                    if (ht[e.Wyplata] == null) {
                        ht.Add(e.Wyplata, true);
                        lista.Add(e.Wyplata);
                    }
                }

        if (wynagr == Periods.Empty) {
            WynagrOd.EditValue = dots;
            WynagrDo.EditValue = dots;
            WynagrLista.EditValue = dots + " </strong>z dnia<strong> " + dots;
        }
        else {
            WynagrOd.EditValue = wynagr.From;
            WynagrDo.EditValue = wynagr.To;
            string ss = "";
            foreach (Wyplata w in lista) {
                if (ss != "")
                    ss += "</strong>,<br><strong> ";
                ss += w.Numer + " </strong>z dnia<strong> " + w.ListaPlac.Data;
            }
            WynagrLista.EditValue = ss;
        }

        if (zas == Periods.Empty) {
            ZasilekOd.EditValue = dots;
            ZasilekDo.EditValue = dots;
            ZasilekLista.EditValue = dots;
            ZasilekData.EditValue = dots;
        }
        else {
            ZasilekOd.EditValue = zas.From;
            ZasilekDo.EditValue = zas.To;
            ZasilekLista.EditValue = wypzas.Numer;
            ZasilekData.EditValue = wypzas.ListaPlac.Data;
        }

        string zla = zwolnienie.Elementy[0].Nieobecność.Zwolnienie.Numer;
        if (zla.Length == 9)
            Zla.EditValue = "</strong>seria<strong> " + zla.Substring(0, 2) + " </strong>numer<strong> " + zla.Substring(2, 7);
        else if (zla != "")
            Zla.EditValue = "</strong>numer<strong> " + zla;
        else
            Zla.EditValue = "</strong>seria<strong> " + dots + " </strong>numer<strong> " + dots;
    }
	
	INieobecnosc Poprzednia(INieobecnosc n) {
		KalkulatorPracy kalk = new KalkulatorPracy(n.Pracownik);
		n = kalk.Nieobecnosc(n.Okres.From-1);
		return n;
	}

    class WypComparer : IComparer<Zwolnienie> {

        public int Compare(Zwolnienie x, Zwolnienie y) {
            return x.Elementy[0].Wyplata.Numer.NumerPelny.CompareTo(y.Elementy[0].Wyplata.Numer.NumerPelny);
        }
    }

    class ElComparer : IComparer<WypElementNieobecność> {

        public int Compare(WypElementNieobecność x, WypElementNieobecność y) {
            return x.Okres.CompareTo(y.Okres);
        }
    }

    class Key {
        
        readonly public INieobecnosc Nieobecnosc;
        
        public Key(INieobecnosc nieobecnosc) {
            this.Nieobecnosc = nieobecnosc;
        }
        public override int GetHashCode() {
            return Nieobecnosc.Okres.GetHashCode() ^ Nieobecnosc.Pracownik.GetHashCode();
        }
        public override bool Equals(object obj) {
            Key k = obj as Key;
            if (k==null)
                return false;
            return Nieobecnosc.Okres.Equals(k.Nieobecnosc.Okres) && Nieobecnosc.Pracownik.Equals(k.Nieobecnosc.Pracownik);
        }
    }

    class Zwolnienie {

        public readonly FromTo OkresNieobecności;
        public readonly List<WypElementNieobecność> Elementy = new List<WypElementNieobecność>();
        public FromTo okres;
        public FromTo Okres {
            get { return okres; }
        }
        public Zwolnienie(FromTo okresNieobecności) {
            OkresNieobecności = okresNieobecności;
        }
        public void Add(WypElementNieobecność element) {
            Elementy.Add(element);
            Elementy.Sort();
            okres = okres.OuterAdd(element.Okres);
        }

        public bool Wchodzi {
            get { return NieobecnośćBezZLA(Elementy[0].Nieobecność) || OkresNieobecności.From < Start; }
        }
        public Pracownik Pracownik {
            get { return Elementy[0].Pracownik; }
        }
        public Nieobecnosc Nieobecność {
            get { return Elementy[0].Nieobecność; }
        }
        Date Start {
            get {
                FromTo okres = Okres;
                Wyplata w = Elementy[0].Wyplata;
                foreach (WypElementNieobecność e in Poprzednie)
                    if (e.Wyplata == w)
                        okres = okres.OuterAdd(e.Okres);
                return okres.From;
            }
        }
        public IEnumerable<WypElementNieobecność> Poprzednie {
            get {
                Pracownik p = Elementy[0].Pracownik;
                foreach (OkresNieobecności on in p.Czasy.Nieobecnosci(OkresNieobecności, true))
                    foreach (WypElement e in ((Nieobecnosc)on).Elementy)
                        if (on.Okres.Contains(e.Okres) && e is WypElementNieobecność && e.Okres.To < Okres.From)
                            yield return (WypElementNieobecność)e;
            }
        }
    }

    void OnContextLoad(Object sender, EventArgs args) {

        Dictionary<Key, Zwolnienie> nieobecności = new Dictionary<Key, Zwolnienie>();
        ListaPlac lista = (ListaPlac)dc[typeof(ListaPlac)];
        foreach (Wyplata w in lista.Wyplaty)
            foreach (WypElement e in w.Elementy)
                if (e.ZasiłekZus && e is WypElementNieobecność && e.BazaZrodla != null && e.StanStorna != StanStornaElementu.Stornujący) {
                    INieobecnosc n = PoczątekZwolnienia((WypElementNieobecność)e);
                    if (n != null) {
                        INieobecnosc kn = KoniecZwolnienia((WypElementNieobecność)e);
                        Key k = new Key(n);
                        Zwolnienie z;
                        if (!nieobecności.TryGetValue(k, out z))
                            nieobecności.Add(k, z = new Zwolnienie(new FromTo(n.Okres.From, kn.Okres.To)));
                        z.Add((WypElementNieobecność)e);
                    }
                }

        List<Zwolnienie> lst = new List<Zwolnienie>();
        foreach (Zwolnienie z in nieobecności.Values) {
            if (z.Wchodzi)
                lst.Add(z);
        }

        lst.Sort(new WypComparer());

        DataRepeater1.DataSource = lst;

        if (lst.Count == 0)
            dc.CancelDocument();
    }

    bool KontynuacjaZwolnienie(INieobecnosc a, INieobecnosc b) {
        return a.Zwolnienie.Numer != "" && a.Zwolnienie.Numer == b.Zwolnienie.Numer;
    }
		    
    INieobecnosc PoczątekZwolnienia(WypElementNieobecność e) {
        INieobecnosc n = Nieobecność(e.Pracownik, e.Okres.From);
        if (n == null)      //Np. wystornowane
            return null;
        while (true) {
            INieobecnosc on = Nieobecność(e.Pracownik, n.Okres.From - 1);
            if (on == null)
                return n;        //Nie ma wcześniejszej nieobecności
            if (!KontynuacjaZwolnienie(n, on))//on.Definicja.Przyczyna != n.Definicja.Przyczyna || on.Zwolnienie.Numer != n.Zwolnienie.Numer)
                return n;       //Jest, ale to już inne zwolnienie
            n = on;
        }
    }

    INieobecnosc KoniecZwolnienia(WypElementNieobecność e) {
        INieobecnosc n = Nieobecność(e.Pracownik, e.Okres.From);
        if (n == null)      //Np. wystornowane
            return null;
        while (true) {
            INieobecnosc on = Nieobecność(e.Pracownik, n.Okres.To + 1);
            if (on == null)
                return n;        //Nie ma wcześniejszej nieobecności
            if (!KontynuacjaZwolnienie(n, on))//on.Definicja.Przyczyna != n.Definicja.Przyczyna || on.Zwolnienie.Numer != n.Zwolnienie.Numer)
                return n;       //Jest, ale to już inne zwolnienie
            n = on;
        }
    }
		    
    static INieobecnosc Nieobecność(Pracownik pracownik, Date data) {
        foreach (INieobecnosc n in pracownik.Czasy.Nieobecnosci(new FromTo(data, data), false))
            return n;
        return null;
    }
		        
    static bool NieobecnośćBezZLA(INieobecnosc n) {
        switch (n.Definicja.Przyczyna) {
            case PrzyczynaNieobecnosci.UrlopMacierzyński:
            case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                return true;
                
            case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
                return n.Zwolnienie.Przyczyna == PrzyczynaZwolnienia.OpiekaSprawowanaNadDziećmi;    //TID: 13451
        }
        return false;
    }
		        
    static Date MinData(WypElement element) {
        Date d = element.Okres.From;
        foreach (WypElement e in element.Wyplata.Elementy)
            if (e.BazaZrodla == element.BazaZrodla && e.Okres.From < d)
                d = e.Okres.From;
        return d;
    }

    protected void DataRepeater1_BeforeRow(object sender, EventArgs args) {
        Zwolnienie zwolnienie = (Zwolnienie)DataRepeater1.CurrentRow;
        Licz1Strona(zwolnienie);
        Grid2.DataSource = zwolnienie.Elementy;
    }
		    	
	public static void Msg(object obj) {
	}

    protected void Grid2_BeforeRow(object sender, RowEventArgs args) {
        WypElementNieobecność e = (WypElementNieobecność)args.Row;

        switch (e.Nieobecność.Definicja.Przyczyna) {
            case PrzyczynaNieobecnosci.UrlopMacierzyński:
                colRodzaj.EditValue = "zasiłek macierzyński";
                break;
            case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
                colRodzaj.EditValue = "zasiłek opiekuńczy";
                break;
            case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                colRodzaj.EditValue = "świadcz. rehabilitacyjne";
                break;
            default:
                if (e.ZasiłekZus)
                    colRodzaj.EditValue = "zasiłek chorobowy";
                else {
                    //colRodzaj.EditValue = "wynagrodznie chorobowe";
                    args.VisibleRow = false;
                }
                break;
        }
    }

</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="DeklaracjaZ7" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" 
                TypeName="Soneta.Place.ListaPlac,Soneta.KadryPlace"></ea:datacontext>
			<ea:datarepeater id="DataRepeater1" runat="server" OnBeforeRow="DataRepeater1_BeforeRow" RowTypeName="Soneta.Place.WypElement,Soneta.KadryPlace"
				Width="100%">
				<ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
				<ea:PageBreak id="PageBreak2" runat="server" BreakFirstTimes="False" ResetPageCounter="true"></ea:PageBreak>
                <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="ZASTĘPCZA ASYGNATA ZASIŁKOWA" runat="server"></cc1:reportheader>
			<P>Stwierdza się, że
				<ea:datalabel id="DataLabel1" runat="server" DataMember="Pracownik.Last.Plec" Bold="False">
					<VALUESMAP>
						<ea:ValuesPair Key="Kobieta" Value="Pani"></ea:ValuesPair>
						<ea:ValuesPair Key="Mężczyzna" Value="Pan"></ea:ValuesPair>
					</VALUESMAP>
				</ea:datalabel>
				<ea:datalabel id="DataLabel5" runat="server" DataMember="Pracownik.ImięNazwisko"></ea:datalabel>
				<ea:datalabel id="DataLabel6" runat="server" DataMember="Pracownik.Last.Plec" Bold="False">
					<VALUESMAP>
						<ea:ValuesPair Key="Kobieta" Value="zamieszkała"></ea:ValuesPair>
						<ea:ValuesPair Key="Mężczyzna" Value="zamieszkały"></ea:ValuesPair>
					</VALUESMAP>
				</ea:datalabel>
				<ea:datalabel id="DataLabel2" runat="server" DataMember="Pracownik.Adres.Linia1"></ea:datalabel>,&nbsp;
				<ea:datalabel id="Datalabel7" runat="server" DataMember="Pracownik.Adres.Linia2"></ea:datalabel>,</P>
			<P>PESEL:
				<ea:datalabel id="DataLabel3" runat="server" DataMember="Pracownik.Last.PESEL"></ea:datalabel>,&nbsp;NIP:
				<ea:datalabel id="DataLabel4" runat="server" DataMember="Pracownik.Last.NIP"></ea:datalabel>,</P>
			<P>
				ma prawo do
				<ea:datalabel id="Datalabel8" runat="server" 
                    DataMember="Nieobecność.Definicja.Przyczyna">
					<VALUESMAP>
						<ea:ValuesPair Key="Urlop macierzyński" Value="zasiłku macierzyńskiego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop opiekuńczy" Value="zasiłku opiekuńczego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop rehabilitacyjny" Value="świadczenia rehebilitacyjnego"></ea:ValuesPair>
						<ea:ValuesPair Key="Zwolnienie chorobowe" Value="zasiłku chorobowego"></ea:ValuesPair>
					</VALUESMAP>
				</ea:datalabel>
				&nbsp;*)</P>
			<P>- dalszego zasiłku za okres od&nbsp;<ea:DataLabel ID="Datalabel9" runat="server" 
                    DataMember="Okres.From">
                <valuesmap>
                    <ea:ValuesPair Key="Urlop macierzyński" Value="zasiłku macierzyńskiego" />
                    <ea:ValuesPair Key="Urlop opiekuńczy" Value="zasiłku opiekuńczego" />
                    <ea:ValuesPair Key="Urlop rehabilitacyjny" 
                        Value="świadczenia rehebilitacyjnego" />
                    <ea:ValuesPair Key="Zwolnienie chorobowe" Value="zasiłku chorobowego" />
                </valuesmap>
                </ea:DataLabel>
                &nbsp;do
                <ea:DataLabel ID="Datalabel10" runat="server" DataMember="Okres.To">
                    <valuesmap>
                        <ea:ValuesPair Key="Urlop macierzyński" Value="zasiłku macierzyńskiego" />
                        <ea:ValuesPair Key="Urlop opiekuńczy" Value="zasiłku opiekuńczego" />
                        <ea:ValuesPair Key="Urlop rehabilitacyjny" 
                            Value="świadczenia rehebilitacyjnego" />
                        <ea:ValuesPair Key="Zwolnienie chorobowe" Value="zasiłku chorobowego" />
                    </valuesmap>
                </ea:DataLabel>
                .</P>
			<P>
				Zaświadczenie o czasowej niezdolności do pracy
				<ea:datalabel id="Zla" runat="server"></ea:datalabel>,</P>
			<P>objemuje okres od
                <ea:DataLabel ID="NieobecnośćOd" runat="server">
                </ea:DataLabel>
                &nbsp;do
                <ea:DataLabel ID="NieobecnośćDo" runat="server">
                </ea:DataLabel>
                .</P>
			<P>Z okresu orzeczonego w powołanym zaświadczeniu wypłacono wynagrodzenie</P>
			<P>
				za okres od
				<ea:datalabel id="WynagrOd" runat="server">
					<VALUESMAP>
						<ea:ValuesPair Key="Urlop macierzyński" Value="zasiłku macierzyńskiego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop opiekuńczy" Value="zasiłku opiekuńczego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop rehabilitacyjny" Value="świadczenia rehebilitacyjnego"></ea:ValuesPair>
						<ea:ValuesPair Key="Zwolnienie chorobowe" Value="zasiłku chorobowego"></ea:ValuesPair>
					</VALUESMAP>
				</ea:datalabel>&nbsp;do
				<ea:datalabel id="WynagrDo" runat="server">
					<VALUESMAP>
						<ea:ValuesPair Key="Urlop macierzyński" Value="zasiłku macierzyńskiego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop opiekuńczy" Value="zasiłku opiekuńczego"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop rehabilitacyjny" Value="świadczenia rehebilitacyjnego"></ea:ValuesPair>
						<ea:ValuesPair Key="Zwolnienie chorobowe" Value="zasiłku chorobowego"></ea:ValuesPair>
					</VALUESMAP>
				</ea:datalabel>&nbsp;</P>
			<P>wg listy płatniczej nr
				<ea:datalabel id="WynagrLista" runat="server"></ea:datalabel>
				.
			<ea:pagebreak id="PageBreak1" runat="server" Required="False"></ea:pagebreak>
			</P>
			<P>-------------------------------------------------------------------------------------------------------------</P>
			<P>
				<ea:datalabel id="Datalabel11" runat="server" 
                    DataMember="Nieobecność.Definicja.Przyczyna">
					<VALUESMAP>
						<ea:ValuesPair Key="Urlop macierzyński" Value="Zasiłek macierzyński"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop opiekuńczy" Value="Zasiłek opiekuńczy"></ea:ValuesPair>
						<ea:ValuesPair Key="Urlop rehabilitacyjny" Value="Świadczenie rehebilitacyjne"></ea:ValuesPair>
						<ea:ValuesPair Key="Zwolnienie chorobowe" Value="Zasiłek chorobowy"></ea:ValuesPair>
					</VALUESMAP>
				</ea:datalabel>&nbsp;*) za okres od
				<ea:datalabel id="ZasilekOd" runat="server"></ea:datalabel>
				&nbsp;do
				<ea:datalabel id="ZasilekDo" runat="server"></ea:datalabel>,</P>
			<P>na podstawie . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
				. . . . . . . . . . . . . . . .</P>
			<P>
				Ostatniej wyplaty dokonano na liście płatniczej nr
				<ea:datalabel id="ZasilekLista" runat="server"></ea:datalabel>&nbsp;z dnia
				<ea:datalabel id="ZasilekData" runat="server"></ea:datalabel>
				.</P>
			<P>-------------------------------------------------------------------------------------------------------------</P>
			<P>*) Wymienić rodzaj zasiłku</P>
			<UL>
				<LI>
				chorobowy
				<LI>
				opiekuńczy
				<LI>
				macierzyński lub w wysokości zasiłku macierzyńskiego
				<LI>
					świadczenie rehabilitacyjne</LI></UL>
			<P>
				<TABLE id="Table1" cellSpacing="0" width="100%">
					<TR>
						<TD width="50%">
							<P align="center">. . . . . . . . . . . . . . . . . . . .
								<BR>
								<FONT size="2">(pieczęć pracodawcy)</FONT></P>
						</TD>
						<TD>
							<P align="center">. . . . . . . . . . . . . . . . . . . .<BR>
								<FONT size="2">(data podpis i pieczęć upoważnionego pracownika)</FONT></P>
						</TD>
					</TR>
				</TABLE>
			</P>
			<P><ea:grid id="Grid2" runat="server" 
                    RowTypeName="Soneta.Place.WypElement,Soneta.KadryPlace" 
                    onbeforerow="Grid2_BeforeRow"><COLUMNS>
						<ea:GridColumn DataMember="#" Width="4" Align="Right" Caption="Lp."></ea:GridColumn>
						<ea:GridColumn Caption="Lista wypłat~Nr" Format="" 
                            DataMember="Wyplata.ListaPlac.Numer.NumerPelny"></ea:GridColumn>
						<ea:GridColumn Width="10" Caption="Lista wypłat~z dnia" DataMember="Data"></ea:GridColumn>
						<ea:GridColumn Width="10" Caption="Lista wypłat~poz." RightBorder="Double" DataMember="Wyplata.Numer.Numer" Align="Right" ></ea:GridColumn>
						<ea:GridColumn ID="colRodzaj" Caption="Rodzaj zasiłku" RightBorder="Double"></ea:GridColumn>
						<ea:GridColumn Width="10" Caption="Stawka %" RightBorder="Double" DataMember="Procent" Align="Right"></ea:GridColumn>
						<ea:GridColumn Width="10" Caption="Zasiłek za okres~od" DataMember="Okres.From"></ea:GridColumn>
						<ea:GridColumn Width="10" Caption="Zasiłek za okres~do" DataMember="Okres.To"></ea:GridColumn>
						<ea:GridColumn Width="10" Caption="Zasiłek za okres~liczba dni" RightBorder="Double" Total="Info" Align="Center" DataMember="Dni"></ea:GridColumn>
						<ea:GridColumn Caption="Do wypłaty" Total="Sum" DataMember="Wartosc" Align="Right"></ea:GridColumn>
					</COLUMNS>
				</ea:grid></P>
			<P>
				<TABLE id="Table2" cellSpacing="0" width="100%">
					<TR>
						<TD width="50%">
							<P align="center">Obliczył . . . . . . . . . . . . . . . . . . . .
								<BR>
							</P>
						</TD>
						<TD>
							<P align="center">Sprawdził . . . . . . . . . . . . . . . . . . . .<BR>
								<FONT size="2">(pieczęć "wypłacono")</FONT></P>
						</TD>
					</TR>
				</TABLE>
			</P>
			<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:ReportFooter>
			<ea:SectionMarker id="SectionMarker6" runat="server" SectionType="Footer"></ea:SectionMarker>
			</ea:datarepeater>
			</form>
	</body>
</HTML>
